package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithWwManagedOrderFlag
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType

@Component
class CampaignWithWwManagedOrderFlagHandler : TypedCampaignResourceHandler<Boolean, CampaignWithWwManagedOrderFlag>() {
    override val resourceType = CampaignResourceType.WW_MANAGED_ORDER_FLAG

    override val campaignToLoad = CampaignWithWwManagedOrderFlag::class.java

    override fun mapCampaignToResource(campaign: CampaignWithWwManagedOrderFlag): Boolean =
        true == campaign.isWwManagedOrder

    override fun fillExportObject(resource: Boolean, builder: Campaign.Builder) {
        builder.isWwManagedOrder = resource
    }
}
