package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.CampaignWithBuilder

interface ICampaignResourceHandler<T> {

    val resourceType: CampaignResourceType

    /**
     * Возвращает ID кампаний, которые будут обновлены этим хэндлером.
     *
     * @param objects объекты с типом [resourceType] или [CampaignResourceType.ALL]
     */
    fun getCampaignsIdsToLoad(shard: Int, objects: Collection<BsExportCampaignObject>): Collection<Long> =
        objects.mapNotNull { it.cid }

    /**
     * Дополняет билдеры кампаний в [campaigns]
     * @param campaigns полностью заполненные объекты кампаний конечных типов
     */
    fun handle(shard: Int, campaigns: Map<Long, CampaignWithBuilder>)
}
