package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRotationGoalId
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType

typealias RotationGoalId = Long

@Component
open class InternalCampaignRotationGoalIdHandler
    : TypedCampaignResourceHandler<RotationGoalId, InternalCampaignWithRotationGoalId>() {

    override val resourceType = CampaignResourceType.INTERNAL_CAMPAIGN_ROTATION_GOAL_ID

    override val campaignToLoad = InternalCampaignWithRotationGoalId::class.java

    override fun fillExportObject(resource: RotationGoalId, builder: Campaign.Builder) {
        builder.rotationGoalId = resource
    }

    override fun mapCampaignToResource(campaign: InternalCampaignWithRotationGoalId): RotationGoalId =
        campaign.rotationGoalId ?: DEFAULT_ROTATION_GOAL_ID

    companion object {
        // в старой Банане по дефолту проставляли цель -1 - оптимизация по ctr
        const val DEFAULT_ROTATION_GOAL_ID: Long = -1
    }
}
