package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import kotlin.reflect.safeCast
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.CampaignWithBuilder

/**
 * Простой хэндлер, обрабатывающий кампании какого-то конкретного типа
 */
abstract class TypedCampaignResourceHandler<T, C : BaseCampaign> : ICampaignResourceHandler<T> {

    abstract val campaignToLoad: Class<C>

    final override fun handle(shard: Int, campaigns: Map<Long, CampaignWithBuilder>) {
        for ((campaign, builder) in campaigns.values) {
            val typedCampaign = campaignToLoad.kotlin.safeCast(campaign)
            if (typedCampaign != null) {
                val resource = mapCampaignToResource(typedCampaign)
                fillExportObject(resource, builder)
            }
        }
    }

    abstract fun mapCampaignToResource(campaign: C): T

    abstract fun fillExportObject(resource: T, builder: Campaign.Builder)
}
