package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.utils;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmDealsCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmYndxFrontpageCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalDistribCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalFreeCampaign;

import static ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform.CONTEXT;
import static ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform.SEARCH;

@Component
public class DisallowedTargetTypesCalculator {

    private static final List<Class> CPM_CAMPAIGNS = List.of(
            CpmBannerCampaign.class, CpmDealsCampaign.class,
            CpmYndxFrontpageCampaign.class, CpmPriceCampaign.class);

    private static final List<Class> INTERNAL_CAMPAIGNS = List.of(
            InternalAutobudgetCampaign.class, InternalDistribCampaign.class, InternalFreeCampaign.class);

    /**
     * Возвращает запрещенные типы площадок.
     * Аналог перлового мтеода https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/Export
     * .pm?rev=7270375#L1657
     */
    public List<Integer> calculate(CommonCampaign campaign) {
        if (CPM_CAMPAIGNS.contains(campaign.getClass())) {
            return List.of(0, 1, 2);
        }
        if (INTERNAL_CAMPAIGNS.contains(campaign.getClass())) {
            return List.of();
        }

        if (campaign instanceof CampaignWithStrategy) {
            var campaignWithStrategy = (CampaignWithStrategy) campaign;
            if (campaignWithStrategy.getStrategy() != null && campaignWithStrategy.getStrategy().getPlatform() != null) {
                if (campaignWithStrategy.getStrategy().getPlatform().equals(SEARCH)) {
                    return List.of(3);
                }
                if (campaignWithStrategy.getStrategy().getPlatform().equals(CONTEXT)) {
                    return List.of(0, 1, 2);
                }
            }
        }
        return List.of();
    }


}
