package ru.yandex.direct.logicprocessor.processors.bsexport.common

import ru.yandex.direct.ess.common.models.BaseLogicObject
import java.util.*


interface ResourcesHandler<TYPE : Enum<TYPE>, OBJ : BaseLogicObject> {
    fun resourceType(): TYPE
    fun handle(shard: Int, objects: Collection<OBJ>)
}

abstract class ResourcesHandlerDispatcher<TYPE : Enum<TYPE>, OBJ : BaseLogicObject, HDLR : ResourcesHandler<TYPE, OBJ>>(
    private val resourceHandlers: List<HDLR>
) {

    private val resourceHandlersMap: Map<TYPE, List<HDLR>> = resourceHandlers
        .map { it.resourceType() to listOf(it) }
        .toMap()

    /**
     * Тип ресурса, который означает "все ресурсы" сразу
     */
    abstract fun getAllTypeValue(): TYPE

    /**
     * Метод получения типа ресурса по объекту, его описывающего
     */
    abstract fun getObjectResourceType(obj: OBJ): TYPE

    private fun getHandlers(resourceType: TYPE?): List<HDLR> = if (getAllTypeValue() == resourceType) {
        resourceHandlers
    } else {
        resourceHandlersMap.getOrDefault(resourceType, listOf())
    }

    fun dispatch(shard: Int, logicObjects: Collection<OBJ>) {
        logicObjects
            .asSequence()
            .map { getObjectResourceType(it) to it }
            .map { (type, obj) -> getHandlers(type) to obj }
            .flatMap { (handlers, obj) -> handlers.map { it to obj } }
            .groupByTo(IdentityHashMap(), { it.first }, { it.second })
            .forEach { (handler, objects) -> handler.handle(shard, objects) }
    }
}
