package ru.yandex.direct.logicprocessor.processors.bsexport.common

import ru.yandex.adv.direct.showcondition.RfOptions
import ru.yandex.direct.utils.TimeConvertUtils

private const val MAX_RF_RESET = 90

fun createRfOptions(
    rf: Int?,
    rfReset: Int?,
    maxClicksCountValue: Int?,
    maxClicksPeriodValue: Int?,
    maxStopsCountValue: Int?,
    maxStopsPeriodValue: Int?
): RfOptions {
    return RfOptions.newBuilder().run {
        if (rf != null && rf > 0) {
            // В этом RF пока не поддерживается значение 0 (весь срок кампании),
            // поэтому при rfReset = 0 проставляем максимальный период (90 дней).
            // Потом в базе аналогично другим полям будем хранить Integer.MAX_VALUE (DIRECT-169842).
            val finalRfReset = if ((rfReset ?: 0) > 0) rfReset!! else MAX_RF_RESET
            val rfResetInSeconds = TimeConvertUtils.daysToSecond(finalRfReset)
            maxShowsCount = rf
            maxShowsPeriod = rfResetInSeconds

            // Удалим, когда движок будет использовать только новый RF (DIRECT-156016).
            stopShowsPeriod = rfResetInSeconds
        }
        maxClicksCountValue?.let { maxClicksCount = it }
        maxClicksPeriodValue?.let { maxClicksPeriod = it }
        maxStopsCountValue?.let { maxStopsCount = it }
        maxStopsPeriodValue?.let { maxStopsPeriod = it }
        build()
    }
}
