package ru.yandex.direct.logicprocessor.processors.bsexport.common

import ru.yandex.adv.direct.expression.keywords.KeywordEnum
import ru.yandex.adv.direct.expression.operations.OperationEnum
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.direct.libs.timetarget.TimeTarget
import ru.yandex.direct.libs.timetarget.WeekdayType

object TimeTargetBsExportUtils {
    private fun hourToLetter(hour: Int): String {
        return ('A' + hour).toString()
    }

    fun addTargetTimeCondition(timeTarget: TimeTarget, builder: TargetingExpression.Builder) {
        val weekdayCoefs = timeTarget.weekdayCoefs.toMutableMap()
        val workingWeekend = weekdayCoefs.remove(WeekdayType.WORKING_WEEKEND) != null
        val masks = mutableListOf<String>()
        val keyword = if (workingWeekend) KeywordEnum.TimetableSimple else KeywordEnum.Timetable
        val operation: OperationEnum

        if (weekdayCoefs[WeekdayType.HOLIDAY] == null) {
            val masksMap = mutableMapOf<String, MutableSet<Int>>()
            weekdayCoefs.forEach { (weekday, coefs) ->
                val mask = (0..23).filter { coefs.getCoefForHour(it) == 0 }
                    .joinToString("", transform = this::hourToLetter)
                masksMap.getOrPut(mask) { mutableSetOf() }.add(weekday.internalNum)
            }
            masksMap.forEach { (hourMask, weekdays) ->
                val dayMask = (1..7).filter { it !in weekdays }.joinToString("") { it.toString() }
                masks.add(dayMask + hourMask)
            }

            operation = OperationEnum.TimeNotLike
        } else {
            val masksMap = mutableMapOf<String, MutableSet<Int>>()
            weekdayCoefs.forEach { (weekday, coefs) ->
                val mask = (0..23).filter { coefs.getCoefForHour(it) != 0 }
                    .joinToString("", transform = this::hourToLetter)
                if (mask.isNotEmpty()) {
                    masksMap.getOrPut(mask) { mutableSetOf() }.add(weekday.internalNum)
                }
            }
            masksMap.forEach { (hourMask, weekdays) ->
                val dayMask = weekdays.sorted().joinToString("") { it.toString() }
                masks.add(dayMask + hourMask)
            }

            operation = OperationEnum.TimeLike
        }

        if (masks.isEmpty() || (masks.size == 1 && masks[0] == "")) {
            return
        }
        masks.sort()
        builder.addAnd(
            TargetingExpression.Disjunction.newBuilder().addAllOr(
                masks.map { ShowConditionUtils.toAtom(keyword, operation, it) }
            )
        )
    }
}
