package ru.yandex.direct.logicprocessor.processors.bsexport.feeds;

import java.util.List;

import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.bsexport.feeds.BsExportFeedsConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.feeds.BsExportFeedsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_BS_EXPORT;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 20),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_2, DIRECT_BS_EXPORT})
@EssLogicProcessor(BsExportFeedsConfig.class)
public class BsExportFeedsProcessor extends BaseLogicProcessor<BsExportFeedsObject> {

    private final BsExportFeedsService bsExportFeedsService;

    public BsExportFeedsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                  BsExportFeedsService bsExportFeedsService) {
        super(essLogicProcessorContext);
        this.bsExportFeedsService = bsExportFeedsService;
    }

    @Override
    public void process(List<BsExportFeedsObject> logicObjects) {
        bsExportFeedsService.processFeeds(getShard(), logicObjects);
    }
}
