package ru.yandex.direct.logicprocessor.processors.bsexport.meaningfulgoals

import org.slf4j.LoggerFactory
import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.ess.config.bsexport.meaningfulgoals.BsExportMeaningfulGoalsConfig
import ru.yandex.direct.ess.logicobjects.bsexport.meaningfulgoals.BsExportMeaningfulGoalsObject
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext

@JugglerCheck(
        ttl = JugglerCheck.Duration(minutes = 20),
        needCheck = ProductionOnly::class,
        tags = [CheckTag.DIRECT_PRIORITY_2, CheckTag.DIRECT_BS_EXPORT],
        notifications = [OnChangeNotification(
                recipient = [NotificationRecipient.LOGIN_SSDMITRIEV],
                status = [JugglerStatus.OK, JugglerStatus.CRIT],
                method = [NotificationMethod.TELEGRAM])])
@EssLogicProcessor(BsExportMeaningfulGoalsConfig::class)
class BsExportMeaningfulGoalsProcessor(
        essLogicProcessorContext: EssLogicProcessorContext,
        private val service: BsExportMeaningfulGoalsService
) : BaseLogicProcessor<BsExportMeaningfulGoalsObject>(essLogicProcessorContext) {

    companion object {
        private val logger = LoggerFactory.getLogger(BsExportMeaningfulGoalsProcessor::class.java)
    }

    override fun process(logicObjects: MutableList<BsExportMeaningfulGoalsObject>) {
        logger.debug("Processing objects for (shard: {}): {}", shard, logicObjects)
        service.processMeaningfulGoals(shard, logicObjects)
    }

}
