package ru.yandex.direct.logicprocessor.processors.bsexport.mobilegoals;

import java.util.List;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.bsexport.mobilegoals.BsExportMobileGoalsExternalTrackerConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.mobilegoals.BsExportMobileGoalsExternalTrackerObject;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_BS_EXPORT;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 20),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_2, DIRECT_BS_EXPORT},
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_SNIRINN,
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        )
)
@EssLogicProcessor(BsExportMobileGoalsExternalTrackerConfig.class)
public class BsExportMobileGoalsExternalTrackerProcessor extends BaseLogicProcessor<BsExportMobileGoalsExternalTrackerObject> {

    private final BsExportMobileGoalsExternalTrackerService bsExportMobileGoalsExternalTrackerService;

    public BsExportMobileGoalsExternalTrackerProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                                       BsExportMobileGoalsExternalTrackerService bsExportMobileGoalsExternalTrackerService) {
        super(essLogicProcessorContext);
        this.bsExportMobileGoalsExternalTrackerService = bsExportMobileGoalsExternalTrackerService;
    }

    @Override
    public void process(List<BsExportMobileGoalsExternalTrackerObject> logicObjects) {
        bsExportMobileGoalsExternalTrackerService.processGoals(getShard(), logicObjects);
    }
}
