package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers

import ru.yandex.adv.direct.expression.CustomExpression
import ru.yandex.adv.direct.expression.MultiplierAtom
import ru.yandex.adv.direct.expression.TargetingExpression
import ru.yandex.adv.direct.expression.TargetingExpressionAtom
import ru.yandex.adv.direct.expression.multipler.type.MultiplierTypeEnum
import ru.yandex.adv.direct.multipliers.Multiplier
import ru.yandex.adv.direct.expression2.TargetingExpression as NewTargetingExpression
import ru.yandex.adv.direct.expression2.TargetingExpressionAtom as NewTargetingExpressionAtom

inline fun buildMultiplierAtom(init: MultiplierAtom.Builder.() -> Unit): MultiplierAtom =
    MultiplierAtom.newBuilder().apply(init).build()

inline fun MultiplierAtom.Builder.buildCondition(init: TargetingExpression.Builder.() -> Unit) {
    conditionBuilder.apply(init)
}

inline fun TargetingExpression.Builder.buildAnd(init: TargetingExpression.Disjunction.Builder.() -> Unit) {
    addANDBuilder().apply(init)
}

inline fun TargetingExpression.Disjunction.Builder.buildOr(init: TargetingExpressionAtom.Builder.() -> Unit) {
    addORBuilder().apply(init)
}

inline fun MultiplierAtom.Builder.buildCustomCondition(init: CustomExpression.Builder.() -> Unit) =
    customConditionBuilder.init()

inline fun CustomExpression.Builder.buildExperimentSegment(init: CustomExpression.SegmentKey.Builder.() -> Unit) =
    experimentSegmentBuilder.init()

fun MultiplierAtom.toExpression2Format(type: MultiplierTypeEnum): Multiplier {
    val builder = Multiplier.newBuilder()
    if (hasCondition()) {
        convertCondition(condition, builder.conditionBuilder)
    }
    if (hasCustomCondition()) {
        builder.customCondition = customCondition
    }
    builder.value = multiplier
    builder.type = type
    return builder.build()
}

private fun convertCondition(
    old: TargetingExpression,
    newBuilder: NewTargetingExpression.Builder
) {
    for (disjunction in old.andList)
        convertDisjunction(disjunction, newBuilder.addAndBuilder())
}

private fun convertDisjunction(
    old: TargetingExpression.Disjunction,
    newBuilder: NewTargetingExpression.Disjunction.Builder
) {
    for (atom in old.orList)
        convertAtom(atom, newBuilder.addOrBuilder())
}

private fun convertAtom(
    old: TargetingExpressionAtom,
    newBuilder: NewTargetingExpressionAtom.Builder
) {
    newBuilder.keyword = old.keyword.number
    newBuilder.operation = old.operation.number
    newBuilder.value = old.value
}
