package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.libs.timetarget.TimeTarget;

@ParametersAreNonnullByDefault
public class CampaignWithTimeTarget {
    private final Long campaignId;
    @Nullable
    private final TimeTarget timeTarget;

    public CampaignWithTimeTarget(Long campaignId, @Nullable TimeTarget timeTarget) {
        this.campaignId = campaignId;
        this.timeTarget = timeTarget;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public TimeTarget getTimeTarget() {
        return timeTarget;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignWithTimeTarget that = (CampaignWithTimeTarget) o;
        return Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(timeTarget, that.timeTarget);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, timeTarget);
    }
}
