package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.adv.direct.expression.MultiplierAtom;
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.MultiplierType;

@ParametersAreNonnullByDefault
public class MultiplierInfo {
    private final MultiplierType type;
    private final Long campaignId;
    @Nullable
    private final Long adGroupId;
    private final Boolean enabled;
    private final List<MultiplierAtom> multipliers;

    public MultiplierInfo(MultiplierType type, Long campaignId, @Nullable Long adGroupId, Boolean enabled,
                          List<MultiplierAtom> multipliers) {
        this.type = type;
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.enabled = enabled;
        this.multipliers = multipliers;
    }

    public MultiplierType getMultiplierType() {
        return type;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public Long getAdGroupId() {
        return adGroupId;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public List<MultiplierAtom> getMultipliers() {
        return multipliers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MultiplierInfo that = (MultiplierInfo) o;
        return type == that.type &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(adGroupId, that.adGroupId) &&
                Objects.equals(enabled, that.enabled) &&
                Objects.equals(multipliers, that.multipliers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, campaignId, adGroupId, enabled, multipliers);
    }

    @Override
    public String toString() {
        return "MultiplierInfo{" +
                "type=" + type +
                ", campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                ", enabled=" + enabled +
                ", multipliers=" + multipliers +
                '}';
    }
}
