package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.expression.MultiplierAtom
import ru.yandex.adv.direct.expression.multipler.type.MultiplierTypeEnum
import ru.yandex.direct.core.entity.bidmodifier.BidModifier
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegment
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegmentAdjustment
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.DeleteInfo
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.MultiplierType
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildCustomCondition
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildExperimentSegment
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildMultiplierAtom
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierAndDeleteInfos
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.handler.MultiplierHandler.MULTIPLIER_COEF

@Component
class AbSegmentMultiplierHandler : BidModifierMultiplierHandler {
    override fun getMultiplierType() = MultiplierType.AB_SEGMENT

    override fun getExportMultiplierType() = MultiplierTypeEnum.AbSegment

    override fun handle(shard: Int, bidModifiers: Collection<BidModifier>): MultiplierAndDeleteInfos {
        val abSegmentModifiers = bidModifiers
            .filterIsInstance<BidModifierABSegment>()

        val multiplierInfos = mutableListOf<MultiplierInfo>()
        val deleteInfos = mutableListOf<DeleteInfo>()
        for (modifier in abSegmentModifiers) {
            // аналогично RetargetingMultiplierHandler
            if (modifier.abSegmentAdjustments != null) {
                val accessibleAdjustments = modifier
                    .abSegmentAdjustments
                    .filter { it.accessible }
                if (accessibleAdjustments.isEmpty()) {
                    deleteInfos += toDeleteInfo(modifier)
                } else {
                    multiplierInfos += toMultiplierInfo(modifier, accessibleAdjustments)
                }
            }
        }

        return MultiplierAndDeleteInfos(multiplierInfos, deleteInfos)
    }

    private fun toDeleteInfo(modifier: BidModifierABSegment) = DeleteInfo(
        MultiplierType.AB_SEGMENT,
        modifier.campaignId,
        modifier.adGroupId
    )

    private fun toMultiplierInfo(
        modifier: BidModifierABSegment,
        accessibleAdjustments: List<BidModifierABSegmentAdjustment>,
    ): MultiplierInfo {
        return MultiplierInfo(
            MultiplierType.AB_SEGMENT,
            modifier.campaignId,
            modifier.adGroupId,
            modifier.enabled,
            accessibleAdjustments.map(this::toMultiplierAtom)
        )
    }

    private fun toMultiplierAtom(adjustment: BidModifierABSegmentAdjustment): MultiplierAtom =
        buildMultiplierAtom {
            multiplier = adjustment.percent * MULTIPLIER_COEF
            buildCustomCondition {
                buildExperimentSegment {
                    dimensionID = adjustment.sectionId
                    segmentID = adjustment.segmentId
                }
            }
        }
}
