package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.expression.multipler.type.MultiplierTypeEnum
import ru.yandex.direct.core.entity.bidmodifier.BidModifier
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.MultiplierType
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildCustomCondition
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildMultiplierAtom
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierInfo

@Component
class AutoVideoDirectMultiplierHandler : BaseMultiplierHandler() {
    override fun getMultiplierType() = MultiplierType.AUTO_VIDEO_DIRECT

    override fun getExportMultiplierType() = MultiplierTypeEnum.AutoVideoDirect

    override fun convert(bidModifiers: Collection<BidModifier>): List<MultiplierInfo> =
        bidModifiers
            .filterIsInstance<BidModifierVideo>()
            .map { modifier ->
                MultiplierInfo(
                    multiplierType,
                    modifier.campaignId,
                    modifier.adGroupId,
                    modifier.enabled,
                    listOf(
                        toMultiplierInfo(modifier.videoAdjustment)
                    ),
                )
            }

    private fun toMultiplierInfo(adjustment: BidModifierVideoAdjustment) =
        buildMultiplierAtom {
            multiplier = adjustment.percent * MULTIPLIER_COEF
            buildCustomCondition {
                autoVideoDirect = "AutoVideoDirect"
            }
        }
}
