package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.handler;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierAndDeleteInfos;
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierInfo;

import static java.util.Collections.emptyList;

abstract public class BaseMultiplierHandler implements BidModifierMultiplierHandler {
    abstract public List<MultiplierInfo> convert(Collection<? extends BidModifier> bidModifiers);

    @Override
    public MultiplierAndDeleteInfos handle(int shard, Collection<? extends BidModifier> bidModifiers) {
        return new MultiplierAndDeleteInfos(convert(bidModifiers), emptyList());
    }
}
