package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.handler;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.adv.direct.expression.MultiplierAtom;
import ru.yandex.adv.direct.expression.TargetingExpression;
import ru.yandex.adv.direct.expression.TargetingExpressionAtom;
import ru.yandex.adv.direct.expression.keywords.KeywordEnum;
import ru.yandex.adv.direct.expression.multipler.type.MultiplierTypeEnum;
import ru.yandex.adv.direct.expression.operations.OperationEnum;
import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierGeo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRegionalAdjustment;
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.MultiplierType;
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierInfo;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class GeoMultiplierHandler extends BaseMultiplierHandler {

    @Override
    public MultiplierType getMultiplierType() {
        return MultiplierType.GEO;
    }

    @Override
    public MultiplierTypeEnum getExportMultiplierType() {
        return MultiplierTypeEnum.Geo;
    }

    @Override
    public List<MultiplierInfo> convert(Collection<? extends BidModifier> bidModifiers) {
        return StreamEx.of(bidModifiers)
                .select(BidModifierGeo.class)
                .map(this::toMultiplierInfo)
                .nonNull()
                .toList();
    }

    @Nullable
    private MultiplierInfo toMultiplierInfo(BidModifierGeo modifier) {
        if (modifier.getRegionalAdjustments() == null) {
            // есть некорректные записи в БД, без значения в geo_multiplier_values,
            // в таких случаях getRegionalAdjustments возвращает null
            // будем пропускать такие записи
            return null;
        }
        return new MultiplierInfo(
                MultiplierType.GEO, modifier.getCampaignId(), modifier.getAdGroupId(), modifier.getEnabled(),
                mapList(modifier.getRegionalAdjustments(), this::toMultiplierAtom)
        );
    }

    private MultiplierAtom toMultiplierAtom(BidModifierRegionalAdjustment adjustment) {
        TargetingExpression.Builder targetingExpressionBuilder = TargetingExpression.newBuilder();
        targetingExpressionBuilder.addAND(
                TargetingExpression.Disjunction.newBuilder()
                        .addOR(
                                TargetingExpressionAtom.newBuilder()
                                        .setKeyword(KeywordEnum.RegId)
                                        .setOperation(OperationEnum.Equal)
                                        .setValue(adjustment.getRegionId().toString())
                                        .build()
                        )
        );
        return MultiplierAtom.newBuilder()
                .setMultiplier(adjustment.getPercent() * MULTIPLIER_COEF)
                .setCondition(targetingExpressionBuilder.build())
                .build();
    }
}
