package ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.expression.multipler.type.MultiplierTypeEnum
import ru.yandex.direct.core.entity.bidmodifier.BidModifier
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgoAdjustment
import ru.yandex.direct.ess.logicobjects.bsexport.multipliers.MultiplierType
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildCustomCondition
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.buildMultiplierAtom
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.container.MultiplierInfo

@Component
class PerformanceTgoMultiplierHandler : BaseMultiplierHandler() {
    override fun getMultiplierType() = MultiplierType.PERFORMANCE_TGO

    override fun getExportMultiplierType() = MultiplierTypeEnum.PerformanceTgo

    override fun convert(bidModifiers: Collection<BidModifier>): List<MultiplierInfo> =
        bidModifiers
            .filterIsInstance<BidModifierPerformanceTgo>()
            .map { modifier ->
                MultiplierInfo(
                    multiplierType,
                    modifier.campaignId,
                    modifier.adGroupId,
                    modifier.enabled,
                    listOf(
                        toMultiplierAtom(modifier.performanceTgoAdjustment)
                    ),
                )
            }

    private fun toMultiplierAtom(adjustment: BidModifierPerformanceTgoAdjustment) =
        buildMultiplierAtom {
            multiplier = adjustment.percent * MULTIPLIER_COEF
            buildCustomCondition {
                performanceTgo = "PerformanceTgo"
            }
        }
}
