package ru.yandex.direct.logicprocessor.processors.bsexport.platformname;

import java.util.Map;
import java.util.function.Predicate;

import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformName;
import ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameInput;

import static ru.yandex.direct.core.entity.banner.model.Language.EN;
import static ru.yandex.direct.core.entity.banner.model.Language.RU_;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.matcher.BannerPlatformNameHrefAndLanguageMatcher.createHrefAndLanguageMatcher;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm.POSTFIX;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm.POSTFIX_YA_FULL;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm.POSTFIX_YA_SHORT;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm.SIMPLE;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm.SIMPLE_YA_FULL;
import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm.SIMPLE_YA_SHORT;


public class BannerPlatformNameConstants {
    private BannerPlatformNameConstants() {
    }

    public static final Language DEFAULT_LANGUAGE = Language.RU_;

    static final String ZEN_NAME = "zen";
    static final String SPRAV_NAME = "sprav";
    static final String MAPS_NAME = "maps";
    static final String USLUGI_NAME = "uslugi";
    static final String MARKET_NAME = "market";
    static final String CLASSIFIED_NAME = "classified";
    static final String GAMES_NAME = "games";
    static final String APPSTORE_NAME = "appstore";
    static final String GOOGLEPLAY_NAME = "googleplay";
    static final String APPGALLERY_NAME = "appgallery";

    private static final String ZEN_REGEXP =
            "^(https?://)(zen\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/zen)/.*";
    private static final String SPRAV_REGEXP =
            "^(https?://)(sprav\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/sprav)/.*";
    private static final String MAPS_REGEXP =
            "^(https?://)(maps\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/maps" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/web-maps)/.*";
    private static final String USLUGI_REGEXP =
            "^(https?://)(uslugi\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/uslugi)/.*";
    private static final String MARKET_REGEXP =
            "^(https?://)(market\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/market" +
                    "|pokupki\\.market\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr))/.*";
    private static final String CLASSIFIED_REGEXP =
            "^(https?://)(o\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/o)/.*";
    private static final String GAMES_REGEXP =
            "^(https?://)(games\\.yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)" +
                    "|yandex\\.(ru|uk|kz|by|uz|com|com\\.tr)/games)/.*";

    private static final String APPSTORE_REGEXP = "^(https?://)(apps\\.apple\\.com|itunes\\.apple\\.com)/.*";
    private static final String GOOGLEPLAY_REGEXP = "^(https?://)(play\\.google\\.com)/.*";
    private static final String APPGALLERY_REGEXP = "^(https?://)(appgallery\\.huawei\\.com)/.*";

    //Дзен не использует short название
    private static final BannerPlatformName RU_ZEN = new BannerPlatformName(
            ZEN_NAME,
            Map.of(SIMPLE, "Дзен",
                    SIMPLE_YA_FULL, "Яндекс.Дзен",
                    POSTFIX, "в Дзене",
                    POSTFIX_YA_FULL, "в Яндекс.Дзене"
            )
    );
    private static final BannerPlatformName EN_ZEN = new BannerPlatformName(
            ZEN_NAME,
            Map.of(SIMPLE, "Zen",
                    SIMPLE_YA_FULL, "Yandex Zen",
                    POSTFIX, "on Zen",
                    POSTFIX_YA_FULL, "on Yandex Zen"
            )
    );
    private static final BannerPlatformName RU_SPRAV = new BannerPlatformName(
            SPRAV_NAME,
            Map.of(SIMPLE, "Справочник",
                    SIMPLE_YA_FULL, "Яндекс.Справочник",
                    SIMPLE_YA_SHORT, "Я.Справочник",
                    POSTFIX, "в Справочнике",
                    POSTFIX_YA_FULL, "в Яндекс.Справочнике",
                    POSTFIX_YA_SHORT, "в Я.Справочнике"
            )
    );
    private static final BannerPlatformName EN_SPRAV = new BannerPlatformName(
            SPRAV_NAME,
            Map.of(SIMPLE, "Directory",
                    SIMPLE_YA_FULL, "Yandex.Directory",
                    SIMPLE_YA_SHORT, "Ya.Directory",
                    POSTFIX, "on Directory",
                    POSTFIX_YA_FULL, "on Yandex.Directory",
                    POSTFIX_YA_SHORT, "on Ya.Directory"
            )
    );
    private static final BannerPlatformName RU_MAPS = new BannerPlatformName(
            MAPS_NAME,
            Map.of(SIMPLE, "Карты",
                    SIMPLE_YA_FULL, "Яндекс.Карты",
                    SIMPLE_YA_SHORT, "Я.Карты",
                    POSTFIX, "на Картах",
                    POSTFIX_YA_FULL, "на Яндекс.Картах",
                    POSTFIX_YA_SHORT, "на Я.Картах"
            )
    );
    private static final BannerPlatformName EN_MAPS = new BannerPlatformName(
            MAPS_NAME,
            Map.of(SIMPLE, "Maps",
                    SIMPLE_YA_FULL, "Yandex.Maps",
                    SIMPLE_YA_SHORT, "Ya.Maps",
                    POSTFIX, "on Maps",
                    POSTFIX_YA_FULL, "on Yandex.Maps",
                    POSTFIX_YA_SHORT, "on Ya.Maps"
            )
    );
    private static final BannerPlatformName RU_USLUGI = new BannerPlatformName(
            USLUGI_NAME,
            Map.of(SIMPLE, "Услуги",
                    SIMPLE_YA_FULL, "Яндекс.Услуги",
                    SIMPLE_YA_SHORT, "Я.Услуги",
                    POSTFIX, "на Услугах",
                    POSTFIX_YA_FULL, "на Яндекс.Услугах",
                    POSTFIX_YA_SHORT, "на Я.Услугах"
            )
    );
    private static final BannerPlatformName EN_USLUGI = new BannerPlatformName(
            USLUGI_NAME,
            Map.of(SIMPLE, "Services",
                    SIMPLE_YA_FULL, "Yandex.Services",
                    SIMPLE_YA_SHORT, "Ya.Services",
                    POSTFIX, "on Services",
                    POSTFIX_YA_FULL, "on Yandex.Services",
                    POSTFIX_YA_SHORT, "on Ya.Services"
            )
    );
    private static final BannerPlatformName RU_MARKET = new BannerPlatformName(
            MARKET_NAME,
            Map.of(SIMPLE, "Маркет",
                    SIMPLE_YA_FULL, "Яндекс.Маркет",
                    SIMPLE_YA_SHORT, "Я.Маркет",
                    POSTFIX, "на Маркете",
                    POSTFIX_YA_FULL, "на Яндекс.Маркете",
                    POSTFIX_YA_SHORT, "на Я.Маркете"
            )
    );
    private static final BannerPlatformName EN_MARKET = new BannerPlatformName(
            MARKET_NAME,
            Map.of(SIMPLE, "Market",
                    SIMPLE_YA_FULL, "Yandex.Market",
                    SIMPLE_YA_SHORT, "Ya.Market",
                    POSTFIX, "on Market",
                    POSTFIX_YA_FULL, "on Yandex.Market",
                    POSTFIX_YA_SHORT, "on Ya.Market"
            )
    );
    private static final BannerPlatformName RU_CLASSIFIED = new BannerPlatformName(
            CLASSIFIED_NAME,
            Map.of(SIMPLE, "Объявления",
                    SIMPLE_YA_FULL, "Яндекс.Объявления",
                    SIMPLE_YA_SHORT, "Я.Объявления",
                    POSTFIX, "на Объявлениях",
                    POSTFIX_YA_FULL, "на Яндекс.Объявлениях",
                    POSTFIX_YA_SHORT, "на Я.Объявлениях"
            )
    );
    private static final BannerPlatformName EN_CLASSIFIED = new BannerPlatformName(
            CLASSIFIED_NAME,
            Map.of(SIMPLE, "Classified",
                    SIMPLE_YA_FULL, "Yandex.Classified",
                    SIMPLE_YA_SHORT, "Ya.Classified",
                    POSTFIX, "on Classified",
                    POSTFIX_YA_FULL, "on Yandex.Classified",
                    POSTFIX_YA_SHORT, "on Ya.Classified"
            )
    );
    private static final BannerPlatformName RU_GAMES = new BannerPlatformName(
            GAMES_NAME,
            Map.of(SIMPLE, "Игры",
                    SIMPLE_YA_FULL, "Яндекс.Игры",
                    SIMPLE_YA_SHORT, "Я.Игры",
                    POSTFIX, "на Играх",
                    POSTFIX_YA_FULL, "на Яндекс.Играх",
                    POSTFIX_YA_SHORT, "на Я.Играх"
            )
    );
    private static final BannerPlatformName EN_GAMES = new BannerPlatformName(
            GAMES_NAME,
            Map.of(SIMPLE, "Games",
                    SIMPLE_YA_FULL, "Yandex.Games",
                    SIMPLE_YA_SHORT, "Ya.Games",
                    POSTFIX, "on Games",
                    POSTFIX_YA_FULL, "on Yandex.Games",
                    POSTFIX_YA_SHORT, "on Ya.Games"
            )
    );
    private static final BannerPlatformName RU_APPSTORE = new BannerPlatformName(
            APPSTORE_NAME,
            Map.of(SIMPLE, "App Store",
                    POSTFIX, "в App Store")
    );
    private static final BannerPlatformName EN_APPSTORE = new BannerPlatformName(
            APPSTORE_NAME,
            Map.of(SIMPLE, "App Store",
                    POSTFIX, "on App Store")
    );
    private static final BannerPlatformName RU_GOOGLEPLAY = new BannerPlatformName(
            GOOGLEPLAY_NAME,
            Map.of(SIMPLE, "Google Play",
                    POSTFIX, "в Google Play")
    );
    private static final BannerPlatformName EN_GOOGLEPLAY = new BannerPlatformName(
            GOOGLEPLAY_NAME,
            Map.of(SIMPLE, "Google Play",
                    POSTFIX, "on Google Play")
    );
    private static final BannerPlatformName RU_APPGALLERY = new BannerPlatformName(
            APPGALLERY_NAME,
            Map.of(SIMPLE, "HUAWEI AppGallery",
                    POSTFIX, "в HUAWEI AppGallery")
    );
    private static final BannerPlatformName EN_APPGALLERY = new BannerPlatformName(
            APPGALLERY_NAME,
            Map.of(SIMPLE, "HUAWEI AppGallery",
                    POSTFIX, "on HUAWEI AppGallery")
    );

    static final Map<Predicate<BannerPlatformNameInput>, BannerPlatformName> PLATFORM_NAME_MAP =
            Map.ofEntries(
                    Map.entry(createHrefAndLanguageMatcher(ZEN_REGEXP, RU_), RU_ZEN),
                    Map.entry(createHrefAndLanguageMatcher(ZEN_REGEXP, EN), EN_ZEN),
                    Map.entry(createHrefAndLanguageMatcher(SPRAV_REGEXP, RU_), RU_SPRAV),
                    Map.entry(createHrefAndLanguageMatcher(SPRAV_REGEXP, EN), EN_SPRAV),
                    Map.entry(createHrefAndLanguageMatcher(MAPS_REGEXP, RU_), RU_MAPS),
                    Map.entry(createHrefAndLanguageMatcher(MAPS_REGEXP, EN), EN_MAPS),
                    Map.entry(createHrefAndLanguageMatcher(USLUGI_REGEXP, RU_), RU_USLUGI),
                    Map.entry(createHrefAndLanguageMatcher(USLUGI_REGEXP, EN), EN_USLUGI),
                    Map.entry(createHrefAndLanguageMatcher(MARKET_REGEXP, RU_), RU_MARKET),
                    Map.entry(createHrefAndLanguageMatcher(MARKET_REGEXP, EN), EN_MARKET),
                    Map.entry(createHrefAndLanguageMatcher(CLASSIFIED_REGEXP, RU_), RU_CLASSIFIED),
                    Map.entry(createHrefAndLanguageMatcher(CLASSIFIED_REGEXP, EN), EN_CLASSIFIED),
                    Map.entry(createHrefAndLanguageMatcher(GAMES_REGEXP, RU_), RU_GAMES),
                    Map.entry(createHrefAndLanguageMatcher(GAMES_REGEXP, EN), EN_GAMES),
                    Map.entry(createHrefAndLanguageMatcher(APPSTORE_REGEXP, RU_), RU_APPSTORE),
                    Map.entry(createHrefAndLanguageMatcher(APPSTORE_REGEXP, EN), EN_APPSTORE),
                    Map.entry(createHrefAndLanguageMatcher(GOOGLEPLAY_REGEXP, RU_), RU_GOOGLEPLAY),
                    Map.entry(createHrefAndLanguageMatcher(GOOGLEPLAY_REGEXP, EN), EN_GOOGLEPLAY),
                    Map.entry(createHrefAndLanguageMatcher(APPGALLERY_REGEXP, RU_), RU_APPGALLERY),
                    Map.entry(createHrefAndLanguageMatcher(APPGALLERY_REGEXP, EN), EN_APPGALLERY)
            );
}
