package ru.yandex.direct.logicprocessor.processors.bsexport.platformname;


import java.util.Map;
import java.util.Optional;

import javax.annotation.Nullable;

import one.util.streamex.EntryStream;

import ru.yandex.adv.direct.banner.resources.PlatformName;
import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformName;
import ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameForm;
import ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameInput;

import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.BannerPlatformNameConstants.PLATFORM_NAME_MAP;

public class BannerPlatformNameExtractor {

    private BannerPlatformNameExtractor() {
    }

    @Nullable
    public static PlatformName getProtoBannerPlatformName(String href, Language language) {
        var platformName = getBannerPlatformName(
                new BannerPlatformNameInput(href, language));
        return platformName.map(BannerPlatformNameExtractor::convertToProto).orElse(null);
    }

    public static Optional<BannerPlatformName> getBannerPlatformName(BannerPlatformNameInput inputKey) {
        return EntryStream.of(PLATFORM_NAME_MAP)
                .filterKeys(matcher -> matcher.test(inputKey))
                .values()
                .findAny();
    }

    private static PlatformName convertToProto(BannerPlatformName platformName) {
        return PlatformName.newBuilder()
                .setName(platformName.getName())
                .setForms(getProtoForms(platformName.getForms()))
                .build();
    }

    private static PlatformName.Forms getProtoForms(Map<BannerPlatformNameForm, String> forms) {
        PlatformName.Forms.Builder builder = PlatformName.Forms.newBuilder();
        forms.forEach((form, value) -> {
            switch (form) {
                case SIMPLE:
                    builder.setSimple(value);
                    break;
                case SIMPLE_YA_FULL:
                    builder.setSimpleYaFull(value);
                    break;
                case SIMPLE_YA_SHORT:
                    builder.setSimpleYaShort(value);
                    break;
                case POSTFIX:
                    builder.setPostfix(value);
                    break;
                case POSTFIX_YA_FULL:
                    builder.setPostfixYaFull(value);
                    break;
                case POSTFIX_YA_SHORT:
                    builder.setPostfixYaShort(value);
                    break;
            }
        });
        return builder.build();
    }

}
