package ru.yandex.direct.logicprocessor.processors.bsexport.platformname.matcher;

import java.util.function.Predicate;
import java.util.regex.Pattern;

import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.logicprocessor.processors.bsexport.platformname.model.BannerPlatformNameInput;

import static ru.yandex.direct.logicprocessor.processors.bsexport.platformname.BannerPlatformNameConstants.DEFAULT_LANGUAGE;

public class BannerPlatformNameHrefAndLanguageMatcher implements Predicate<BannerPlatformNameInput> {

    private final Predicate<String> hrefPredicate;
    private final Language language;

    private BannerPlatformNameHrefAndLanguageMatcher(String hrefRegexp,
                                                     Language language) {
        this.hrefPredicate = Pattern.compile(hrefRegexp).asMatchPredicate();
        this.language = language;
    }

    public static BannerPlatformNameHrefAndLanguageMatcher createHrefAndLanguageMatcher(String hrefRegexp,
                                                                                        Language language) {
        return new BannerPlatformNameHrefAndLanguageMatcher(hrefRegexp, language);
    }

    @Override
    public boolean test(BannerPlatformNameInput inputKey) {
        Language bannerLanguage = getLanguage(inputKey);
        String href = inputKey.getHref();
        return href != null && hrefPredicate.test(href) && language.equals(bannerLanguage);
    }

    private Language getLanguage(BannerPlatformNameInput inputKey) {
        Language bannerLanguage = inputKey.getLanguage();
        if (bannerLanguage == null || bannerLanguage == Language.UNKNOWN) {
            return DEFAULT_LANGUAGE;
        }
        return bannerLanguage;
    }
}
