package ru.yandex.direct.logicprocessor.processors.bsexport.resources

import java.util.IdentityHashMap
import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler.BannerResourcesHandlerProvider
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler.IBannerResourcesHandler

@Component
class BsExportBannerResourcesService(
    private val bannerResourcesHandlerProvider: BannerResourcesHandlerProvider) {

    companion object {
        private val logger: Logger = LoggerFactory.getLogger(BsExportBannerResourcesService::class.java)
    }

    fun updateResources(shard: Int, logicObjects: List<BsExportBannerResourcesObject>) {
        val handlerToObjectsMap = getHandlerToObjectsMap(logicObjects)
        handlerToObjectsMap.forEach { (handler, objects) -> handler.handle(shard, objects) }
    }

    fun getHandlerToObjectsMap(logicObjects: List<BsExportBannerResourcesObject>): Map<IBannerResourcesHandler, List<BsExportBannerResourcesObject>> {
        logger.info("Logic objects size ${logicObjects.size}")
        val filteredObjects = logicObjects
            .filter { it.debugInfo?.method != "bsExportMaster" && it.debugInfo?.method != "bsClientData" }
        logger.info("Filtered logic objects size ${filteredObjects.size}")
        return filteredObjects
            .map { bannerResourcesHandlerProvider[it.resourceType] to it }
            .flatMap { (key, value) -> key.map { it to value } }
            .groupByTo(IdentityHashMap(), { it.first }, { it.second })
    }
}
