package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;

import java.util.Objects;

import static com.google.common.base.Preconditions.checkArgument;

public class BannerResource<T> {
    private final long bid;
    private final long pid;
    private final long cid;
    private final long bsBannerId;
    private final long orderId;
    private final T resource;

    private BannerResource(long bid, long pid, long cid, long bsBannerId, long orderId, T resource) {
        this.bid = bid;
        this.pid = pid;
        this.cid = cid;
        this.bsBannerId = bsBannerId;
        this.orderId = orderId;
        this.resource = resource;
    }

    public Long getBid() {
        return bid;
    }

    public long getPid() {
        return pid;
    }

    public long getCid() {
        return cid;
    }

    public long getBsBannerId() {
        return bsBannerId;
    }

    public long getOrderId() {
        return orderId;
    }

    public T getResource() {
        return resource;
    }

    @Override
    public String toString() {
        return "BannerResource{" +
                "bid=" + bid +
                ", pid=" + pid +
                ", cid=" + cid +
                ", bsBannerId=" + bsBannerId +
                ", orderId=" + orderId +
                ", resource=" + resource +
                '}';
    }

    public static class Builder<T> {
        private Long bid;
        private Long pid;
        private Long cid;
        private Long bsBannerId;
        private Long orderId;
        private T resource;

        public Builder<T> setBid(long bid) {
            this.bid = bid;
            return this;
        }

        public Builder<T> setPid(long pid) {
            this.pid = pid;
            return this;
        }

        public Builder<T> setCid(long cid) {
            this.cid = cid;
            return this;
        }

        public Builder<T> setBsBannerId(long bsBannerId) {
            this.bsBannerId = bsBannerId;
            return this;
        }

        public Builder<T> setOrderId(long orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder<T> setResource(T resource) {
            this.resource = resource;
            return this;
        }

        public BannerResource<T> build() {
            checkArgument(Objects.nonNull(bid));
            checkArgument(Objects.nonNull(pid));
            checkArgument(Objects.nonNull(cid));
            checkArgument(Objects.nonNull(bsBannerId));
            checkArgument(Objects.nonNull(orderId));
            return new BannerResource<>(bid, pid, cid, bsBannerId, orderId, resource);
        }
    }

    public BannerResource<T> getImageBannerResource(Long imageId, Long imageBannerID) {
        checkArgument(Objects.nonNull(imageId));
        checkArgument(Objects.nonNull(imageBannerID));
        return new BannerResource<>(imageId, pid, cid, imageBannerID, orderId, resource);
    }
}
