package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;

import javax.annotation.Nullable;

import ru.yandex.adv.direct.banner.resources.PlatformName;

public class HrefsInfo {
    private final String href;
    private final String site;
    private final String domainFilter;
    private final String siteFilter;
    private final Long domainFilterId;
    private final Long siteFilterId;
    private final PlatformName platformName;

    private HrefsInfo(String href, String site, String domainFilter, String siteFilter, Long domainFilterId,
                      Long siteFilterId, @Nullable PlatformName platformName) {
        this.href = href;
        this.site = site;
        this.domainFilter = domainFilter;
        this.siteFilter = siteFilter;
        this.domainFilterId = domainFilterId;
        this.siteFilterId = siteFilterId;
        this.platformName = platformName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHref() {
        return href;
    }

    public String getSite() {
        return site;
    }

    public String getDomainFilter() {
        return domainFilter;
    }

    public String getSiteFilter() {
        return siteFilter;
    }

    public Long getDomainFilterId() {
        return domainFilterId;
    }

    public Long getSiteFilterId() {
        return siteFilterId;
    }

    @Nullable
    public PlatformName getPlatformName() {
        return platformName;
    }

    @Override
    public String toString() {
        return "HrefsInfo{" +
                "href='" + href + '\'' +
                ", site='" + site + '\'' +
                ", domainFilter='" + domainFilter + '\'' +
                ", siteFilter='" + siteFilter + '\'' +
                ", domainFilterId=" + domainFilterId +
                ", siteFilterId=" + siteFilterId +
                ", platformName=" + platformName +
                '}';
    }

    public static class Builder {
        private String href;
        private String site;
        private String domainFilter;
        private String siteFilter;
        private Long domainFilterId;
        private Long siteFilterId;
        private PlatformName platformName;

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withSite(String site) {
            this.site = site;
            return this;
        }

        public Builder withDomainFilter(String domainFilter) {
            this.domainFilter = domainFilter;
            return this;
        }

        public Builder withSiteFilter(String siteFilter) {
            this.siteFilter = siteFilter;
            return this;
        }

        public Builder withDomainFilterId(Long domainFilterId) {
            this.domainFilterId = domainFilterId;
            return this;
        }

        public Builder withSiteFilterId(Long siteFilterId) {
            this.siteFilterId = siteFilterId;
            return this;
        }

        public Builder withPlatformName(@Nullable PlatformName platformName) {
            this.platformName = platformName;
            return this;
        }

        public HrefsInfo build() {
            return new HrefsInfo(href, site, domainFilter, siteFilter, domainFilterId, siteFilterId, platformName);
        }
    }
}
