package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;

import javax.annotation.Nullable;

import ru.yandex.adv.direct.banner.resources.PlatformName;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

public class MobileContentInfo {
    private final long id;
    private final String bundleId;
    private final OsType osType;
    private final String href;
    private final String site;
    private final String domainFilter;
    private final String siteFilter;
    private final PlatformName platformName;
    private final String lang;
    private final String region;

    private MobileContentInfo(
            long id,
            String bundleId,
            OsType osType,
            String href,
            String site,
            String domainFilter,
            String siteFilter,
            @Nullable PlatformName platformName,
            String lang,
            String region) {
        this.id = id;
        this.bundleId = bundleId;
        this.osType = osType;
        this.href = href;
        this.site = site;
        this.domainFilter = domainFilter;
        this.siteFilter = siteFilter;
        this.platformName = platformName;
        this.lang = lang;
        this.region = region;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getId() {
        return id;
    }

    public String getBundleId() {
        return bundleId;
    }

    public OsType getOsType() {
        return osType;
    }

    public String getHref() {
        return href;
    }

    public String getSite() {
        return site;
    }

    public String getDomainFilter() {
        return domainFilter;
    }

    public String getSiteFilter() {
        return siteFilter;
    }

    @Nullable
    public PlatformName getPlatformName() {
        return platformName;
    }

    public String getLang() {
        return lang;
    }

    public String getRegion() {
        return region;
    }

    @Override
    public String toString() {
        return "MobileContentInfo{" +
                "id=" + id +
                ", bundleId='" + bundleId + '\'' +
                ", osType=" + osType +
                ", href='" + href + '\'' +
                ", site='" + site + '\'' +
                ", domainFilter='" + domainFilter + '\'' +
                ", siteFilter='" + siteFilter + '\'' +
                ", platformName=" + platformName +
                ", lang='" + lang + '\'' +
                ", region='" + region + '\'' +
                '}';
    }

    public static class Builder {
        private Long id;
        private String bundleId;
        private OsType osType;
        private String href;
        private String site;
        private String domainFilter;
        private String siteFilter;
        private PlatformName platformName;
        private String lang;
        private String region;

        public Builder() {
        }

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withBundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public Builder withOsType(OsType osType) {
            this.osType = osType;
            return this;
        }

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withSite(String site) {
            this.site = site;
            return this;
        }

        public Builder withDomainFilter(String domainFilter) {
            this.domainFilter = domainFilter;
            return this;
        }

        public Builder withSiteFilter(String siteFilter) {
            this.siteFilter = siteFilter;
            return this;
        }

        public Builder withPlatformName(@Nullable PlatformName platformName) {
            this.platformName = platformName;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public MobileContentInfo build() {
            return new MobileContentInfo(id, bundleId, osType, href, site, domainFilter, siteFilter, platformName,
                    lang, region);
        }
    }
}
