package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;


import java.util.List;

import ru.yandex.direct.core.bsexport.resources.model.PermalinkAssignType;

public class PermalinksInfo {
    private final Long id;
    private final String href;
    private final String site;
    private final String domainFilter;
    private final PermalinkAssignType assignType;
    private final List<Long> chainIds;

    private PermalinksInfo(Long id, String href, String site, String domainFilter,
                           PermalinkAssignType assignType, List<Long> chainIds) {
        this.id = id;
        this.href = href;
        this.site = site;
        this.domainFilter = domainFilter;
        this.assignType = assignType;
        this.chainIds = chainIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHref() {
        return href;
    }

    public String getSite() {
        return site;
    }

    public String getDomainFilter() {
        return domainFilter;
    }

    public Long getId() {
        return id;
    }

    public PermalinkAssignType getAssignType() {
        return assignType;
    }

    public List<Long> getChainIds() {
        return chainIds;
    }

    @Override
    public String toString() {
        return "PermalinksInfo{" +
                "id=" + id +
                ", href='" + href + '\'' +
                ", site='" + site + '\'' +
                ", domainFilter='" + domainFilter + '\'' +
                ", assignType=" + assignType +
                ", chainIDs=" + chainIds +
                '}';
    }

    public static class Builder {
        private Long permalinkId;
        private String permalinkHref;
        private String permalinkSite;
        private String permalinkDomainFilter;
        private PermalinkAssignType permalinkAssignType;
        private List<Long> permalinkChainIds;

        public Builder withPermalinkId(Long permalinkId) {
            this.permalinkId = permalinkId;
            return this;
        }

        public Builder withPermalinkHref(String permalinkHref) {
            this.permalinkHref = permalinkHref;
            return this;
        }

        public Builder withPermalinkSite(String permalinkSite) {
            this.permalinkSite = permalinkSite;
            return this;
        }

        public Builder withPermalinkDomainFilter(String permalinkDomainFilter) {
            this.permalinkDomainFilter = permalinkDomainFilter;
            return this;
        }

        public Builder withPermalinkAssignType(PermalinkAssignType permalinkAssignType) {
            this.permalinkAssignType = permalinkAssignType;
            return this;
        }

        public Builder withPermalinkChainIds(List<Long> permalinkChainIds) {
            this.permalinkChainIds = permalinkChainIds;
            return this;
        }

        public PermalinksInfo build() {
            return new PermalinksInfo(permalinkId, permalinkHref, permalinkSite, permalinkDomainFilter,
                    permalinkAssignType, permalinkChainIds);
        }
    }
}
