package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;

public class TitleAndBody {
    private final String title;
    private final String body;

    public TitleAndBody(String title, String body) {
        this.title = title;
        this.body = body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTitle() {
        return title;
    }

    public String getBody() {
        return body;
    }

    @Override
    public String toString() {
        return "TitleAndBody{" +
                "title='" + title + '\'' +
                ", body='" + body + '\'' +
                '}';
    }

    public static class Builder {
        private String title;
        private String body;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public TitleAndBody build() {
            return new TitleAndBody(title, body);
        }
    }
}
