package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;

public class TurboLandingInfo {
    private final long turbolandingId;
    private final String href;
    private final String site;
    private final String domainFilter;

    public TurboLandingInfo(long turbolandingId, String href, String site, String domainFilter) {
        this.turbolandingId = turbolandingId;
        this.href = href;
        this.site = site;
        this.domainFilter = domainFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getTurbolandingId() {
        return turbolandingId;
    }

    public String getHref() {
        return href;
    }

    public String getSite() {
        return site;
    }

    public String getDomainFilter() {
        return domainFilter;
    }

    @Override
    public String toString() {
        return "TurboLandingInfo{" +
                "turbolandingId=" + turbolandingId +
                ", href='" + href + '\'' +
                ", site='" + site + '\'' +
                ", domainFilter='" + domainFilter + '\'' +
                '}';
    }

    public static class Builder {
        private long turbolandingId;
        private String href;
        private String site;
        private String domainFilter;

        public Builder withTurbolandingId(long turbolandingId) {
            this.turbolandingId = turbolandingId;
            return this;
        }

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withSite(String site) {
            this.site = site;
            return this;
        }

        public Builder withDomainFilter(String domainFilter) {
            this.domainFilter = domainFilter;
            return this;
        }

        public TurboLandingInfo build() {
            return new TurboLandingInfo(turbolandingId, href, site, domainFilter);
        }
    }
}
