package ru.yandex.direct.logicprocessor.processors.bsexport.resources.container;

public class VcardInfo {
    private final String domainFilter;

    private VcardInfo(String domainFilter) {
        this.domainFilter = domainFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDomainFilter() {
        return domainFilter;
    }

    @Override
    public String toString() {
        return "VcardInfo{" +
                "domainFilter='" + domainFilter + '\'' +
                '}';
    }

    public static class Builder {
        private String domainFilter;


        public Builder withDomainFilter(String domainFilter) {
            this.domainFilter = domainFilter;
            return this;
        }

        public VcardInfo build() {
            return new VcardInfo(domainFilter);
        }
    }
}
