package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.Button
import ru.yandex.adv.direct.banner.resources.OptionalButton
import ru.yandex.direct.bstransport.yt.repository.resources.BannerButtonYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerButtonsLoader
import java.util.*

@Component
class BannerButtonsHandler(
    loader: BannerButtonsLoader,
    ytRepository: BannerButtonYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<Button?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_BUTTON
    }

    override fun mapResourceToProto(): (Button?, BannerResources.Builder) -> Unit {
        return { button, resourcesBuilder -> resourcesBuilder.button = getOptionalButtonFromButton(button) }
    }

    private fun getOptionalButtonFromButton(button: Button?): OptionalButton {
        return if (Objects.isNull(button)) {
            OptionalButton.newBuilder().build()
        } else {
            OptionalButton.newBuilder().setValue(button).build()
        }
    }
}
