package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.BannerGreenUrlTextsYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.GreenUrlTexts
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerGreenUrlTextsLoader
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class BannerGreenUrlTextsHandler(
    loader: BannerGreenUrlTextsLoader,
    ytRepository: BannerGreenUrlTextsYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<GreenUrlTexts>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {

    public override fun mapResourceToProto(): (GreenUrlTexts?, BannerResources.Builder) -> Unit =
        { greenUrlTexts, builder ->
            builder.greenUrlTextPrefix = greenUrlTexts?.greenUrlTextPrefix ?: ""
            builder.greenUrlTextSuffix = greenUrlTexts?.greenUrlTextSuffix ?: ""
        }

    override fun bannerResourceType() = BannerResourceType.BANNER_GREEN_URL_TEXTS

}
