package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.OptionalPlatformName
import ru.yandex.adv.direct.banner.resources.PlatformName
import ru.yandex.direct.bstransport.yt.repository.resources.BannerHrefYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.HrefsInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerHrefLoader
import java.util.*

@Component
class BannerHrefHandler(
    loader: BannerHrefLoader,
    ytRepository: BannerHrefYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<HrefsInfo>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_HREF
    }

    override fun mapResourceToProto(): (HrefsInfo, BannerResources.Builder) -> Unit {
        return { hrefsInfo, resourcesBuilder ->
            resourcesBuilder
                .setHref(hrefsInfo.href)
                .setSite(hrefsInfo.site)
                .setDomainFilter(hrefsInfo.domainFilter)
                .setSiteFilter(hrefsInfo.siteFilter)
                .setDomainFilterId(hrefsInfo.domainFilterId)
                .setSiteFilterId(hrefsInfo.siteFilterId)
                .setPlatformName(getOptionalPlatformName(hrefsInfo.platformName))
        }
    }

    private fun getOptionalPlatformName(platformName: PlatformName?): OptionalPlatformName {
        return if (Objects.isNull(platformName)) {
            OptionalPlatformName.newBuilder().build()
        } else {
            OptionalPlatformName.newBuilder().setValue(platformName).build()
        }
    }

}
