package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.LeadButton
import ru.yandex.adv.direct.banner.resources.OptionalLeadButton
import ru.yandex.direct.bstransport.yt.repository.resources.BannerLeadButtonYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerLeadButtonLoader
import java.util.*

@Component
class BannerLeadButtonHandler(
    loader: BannerLeadButtonLoader,
    ytRepository: BannerLeadButtonYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<LeadButton?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_LEAD_BUTTON
    }

    override fun mapResourceToProto(): (LeadButton?, BannerResources.Builder) -> Unit {
        return { leadButton, resourcesBuilder ->
            resourcesBuilder.leadButton = getOptionalLeadButtonFromLeadButton(leadButton)
        }
    }

    private fun getOptionalLeadButtonFromLeadButton(leadButton: LeadButton?): OptionalLeadButton {
        return if (Objects.isNull(leadButton)) {
            OptionalLeadButton.newBuilder().build()
        } else {
            OptionalLeadButton.newBuilder().setValue(leadButton).build()
        }
    }
}
