package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.Logo
import ru.yandex.adv.direct.banner.resources.OptionalLogo
import ru.yandex.direct.bstransport.yt.repository.resources.BannerLogoYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerLogosLoader
import java.util.*

@Component
class BannerLogosHandler(
    loader: BannerLogosLoader,
    ytRepository: BannerLogoYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<Logo?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_LOGO
    }

    override fun mapResourceToProto(): (Logo?, BannerResources.Builder) -> Unit {
        return { logo, resourcesBuilder -> resourcesBuilder.logo = getOptionalLogoFromLogo(logo) }
    }

    private fun getOptionalLogoFromLogo(logo: Logo?): OptionalLogo {
        return if (Objects.isNull(logo)) {
            OptionalLogo.newBuilder().build()
        } else {
            OptionalLogo.newBuilder().setValue(logo).build()
        }
    }
}
