package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.MobileContentSource
import ru.yandex.adv.direct.banner.resources.OptionalPlatformName
import ru.yandex.adv.direct.banner.resources.PlatformName
import ru.yandex.direct.bstransport.yt.repository.resources.BannerMobileContentYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.core.entity.mobilecontent.model.OsType
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.MobileContentInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerMobileContentLoader
import java.util.*

@Component
class BannerMobileContentHandler(
    loader: BannerMobileContentLoader,
    ytRepository: BannerMobileContentYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<MobileContentInfo>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {

    companion object {
        private val osTypeToSource: Map<OsType, MobileContentSource> = mapOf(
            OsType.ANDROID to MobileContentSource.MOBILE_CONTENT_GOOGLE_PLAY_STORE,
            OsType.IOS to MobileContentSource.MOBILE_CONTENT_APPLE_APP_STORE,
        )
    }

    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_MOBILE_CONTENT
    }

    override fun mapResourceToProto(): (MobileContentInfo, BannerResources.Builder) -> Unit {
        return { mobileContentInfo, resourcesBuilder ->
            resourcesBuilder
                .setMobileContentId(mobileContentInfo.id)
                .setMobileContentBundleId(mobileContentInfo.bundleId)
                .setMobileContentSource(toSource(mobileContentInfo.osType).number)
                .setMobileContentHref(mobileContentInfo.href)
                .setMobileContentSite(mobileContentInfo.site)
                .setMobileContentSiteFilter(mobileContentInfo.siteFilter)
                .setMobileContentDomainFilter(mobileContentInfo.domainFilter)
                .setPlatformName(getOptionalPlatformName(mobileContentInfo.platformName))
                .setMobileContentLocal(mobileContentInfo.lang)
                .setMobileContentRegion(mobileContentInfo.region)
        }
    }

    private fun getOptionalPlatformName(platformName: PlatformName?): OptionalPlatformName {
        return if (Objects.isNull(platformName)) {
            OptionalPlatformName.newBuilder().build()
        } else {
            OptionalPlatformName.newBuilder().setValue(platformName).build()
        }
    }

    private fun toSource(osType: OsType): MobileContentSource {
        return osTypeToSource[osType] ?: MobileContentSource.MOBILE_CONTENT_INVALID
    }
}
