package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.MulticardSet
import ru.yandex.direct.bstransport.yt.repository.resources.BannerMulticardSetYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerMulticardSetLoader

@Component
class BannerMulticardSetHandler(
    loader: BannerMulticardSetLoader,
    private val ytRepository: BannerMulticardSetYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<MulticardSet?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType() = BannerResourceType.BANNER_MULTICARD

    public override fun mapResourceToProto(): (MulticardSet?, BannerResources.Builder) -> Unit {
        return { multicardSet, builder ->
            builder.multicardSet = ytRepository.getOptionalMulticardSet(multicardSet)
        }
    }
}
