package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.UInt64List
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.BannerPermalinksYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.PermalinksInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerPermalinksLoader

@Component
open class BannerPermalinksHandler(
    loader: BannerPermalinksLoader,
    ytRepository: BannerPermalinksYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<PermalinksInfo?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_PERMALINKS
    }

    override fun mapResourceToProto(): (PermalinksInfo?, BannerResources.Builder) -> Unit {
        return { permalinksInfo, resourcesBuilder ->
            val permalinkHref = permalinksInfo?.href ?: ""
            val permalinkSite = permalinksInfo?.site ?: ""
            val permalinkDomainFilter = permalinksInfo?.domainFilter ?: ""
            val permalinkId = permalinksInfo?.id ?: 0
            val permalinkAssignType = permalinksInfo?.assignType?.toString()?.toLowerCase() ?: ""
            val permalinkChainIds = permalinksInfo?.chainIds ?: listOf()

            resourcesBuilder
                .setPermalinkHref(permalinkHref)
                .setPermalinkSite(permalinkSite)
                .setPermalinkDomainFilter(permalinkDomainFilter)
                .setPermalinkId(permalinkId)
                .setPermalinkAssignType(permalinkAssignType).permalinkChainIds = UInt64List.newBuilder()
                .addAllValues(permalinkChainIds)
                .build()
        }
    }
}
