package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.PromoExtension
import ru.yandex.direct.bstransport.yt.repository.resources.BannerPromoExtensionsYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerPromoExtensionLoader

@Component
class BannerPromoExtensionHandler(
    loader: BannerPromoExtensionLoader,
    private val ytRepository: BannerPromoExtensionsYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<PromoExtension?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType() = BannerResourceType.BANNER_PROMO_EXTENSION

    public override fun mapResourceToProto(): (PromoExtension?, BannerResources.Builder) -> Unit {
        return { promoExtension, builder ->
            builder.promoExtension = ytRepository.getOptionalPromoExtension(promoExtension)
        }
    }
}
