package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import java.util.*

@Component
class BannerResourcesHandlerProvider(bannerResourceHandlers: List<IBannerResourcesHandler>) {
    private val resourceHandlersMap: MutableMap<BannerResourceType, List<IBannerResourcesHandler>>

    operator fun get(bannerResourceType: BannerResourceType?): List<IBannerResourcesHandler> {
        return resourceHandlersMap.getOrDefault(bannerResourceType, listOf())
    }

    init {
        resourceHandlersMap = EnumMap(BannerResourceType::class.java)
        bannerResourceHandlers
            .forEach { resourceHandlersMap[it.bannerResourceType()] = listOf(it) }

        resourceHandlersMap[BannerResourceType.ALL] = bannerResourceHandlers
    }
}
