package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.solomon.SolomonUtils
import ru.yandex.monlib.metrics.labels.Labels
import ru.yandex.monlib.metrics.primitives.Counter

import ru.yandex.monlib.metrics.primitives.Rate
import java.util.concurrent.ConcurrentHashMap

class BannerResourcesMonitoring(private val bannerResourceType: BannerResourceType) {
    private val sentResourcesCount: MutableMap<Labels, Counter> = ConcurrentHashMap()
    private val candidatesToSentCount: MutableMap<Labels, Counter> = ConcurrentHashMap()

    private val sentResourcesRate: MutableMap<Labels, Rate> = ConcurrentHashMap()
    private val candidatesToSentRate: MutableMap<Labels, Rate> = ConcurrentHashMap()
    private val metricRegistry = SolomonUtils.SOLOMON_REGISTRY
        .subRegistry(Labels.of(BS_EXPORT_TYPE_LABEL, "resources"))

    companion object {
        private const val SHARD_LABEL = "shard"
        private const val RESOURCE_TYPE_LABEL = "resource_type"
        private const val BS_EXPORT_TYPE_LABEL = "bs_export_type"
    }

    fun addSentResources(shard: Int, n: Int) {
        addCounterMetric(sentResourcesCount, "sent", shard, n)
        addRateMetric(sentResourcesRate, "sentRate", shard, n)
    }

    fun addCandidatesToSendResources(shard: Int, n: Int) {
        addCounterMetric(candidatesToSentCount, "candidates", shard, n)
        addRateMetric(candidatesToSentRate, "candidatesRate", shard, n)
    }

    // попробуем 2 типа метрик, оставим тот, который лучше DIRECT-134446
    private fun addRateMetric(counterMap: MutableMap<Labels, Rate>, metricName: String, shard: Int, n: Int) {
        val shardString = shard.toString()
        listOf(
            Labels.of(RESOURCE_TYPE_LABEL, bannerResourceType.name, SHARD_LABEL, shardString),
            Labels.of(RESOURCE_TYPE_LABEL, bannerResourceType.name, SHARD_LABEL, "all"),
            Labels.of(RESOURCE_TYPE_LABEL, "all", SHARD_LABEL, shardString),
            Labels.of(RESOURCE_TYPE_LABEL, "all", SHARD_LABEL, "all"),
        ).forEach { labels ->
            counterMap.computeIfAbsent(labels) { metricRegistry.rate(metricName, labels) }
                .add(n.toLong())
        }
    }

    private fun addCounterMetric(counterMap: MutableMap<Labels, Counter>, metricName: String, shard: Int, n: Int) {
        val shardString = shard.toString()
        listOf(
            Labels.of(RESOURCE_TYPE_LABEL, bannerResourceType.name, SHARD_LABEL, shardString),
            Labels.of(RESOURCE_TYPE_LABEL, bannerResourceType.name, SHARD_LABEL, "all"),
            Labels.of(RESOURCE_TYPE_LABEL, "all", SHARD_LABEL, shardString),
            Labels.of(RESOURCE_TYPE_LABEL, "all", SHARD_LABEL, "all"),
        ).forEach { labels ->
            counterMap.computeIfAbsent(labels) { metricRegistry.counter(metricName, labels) }
                .add(n.toLong())
        }
    }
}
