package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.BannerTitleAndBodyYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.TitleAndBody
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerTitleAndBodyLoader

@Component
class BannerTitleAndBodyHandler(
    loader: BannerTitleAndBodyLoader,
    ytRepository: BannerTitleAndBodyYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<TitleAndBody>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_TITLE_AND_BODY
    }

    override fun mapResourceToProto(): (TitleAndBody, BannerResources.Builder) -> Unit {
        return { titleAndBody, resourcesBuilder ->
            resourcesBuilder
                .setTitle(titleAndBody.title)
                .setBody(titleAndBody.body)
        }
    }
}
