package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.BannerTurbolandingYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.TurboLandingInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerTurboLandingsLoader

@Component
open class BannerTurboLandingHandler(
    loader: BannerTurboLandingsLoader,
    ytRepository: BannerTurbolandingYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<TurboLandingInfo?>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_TURBOLANDING
    }

    override fun mapResourceToProto(): (TurboLandingInfo?, BannerResources.Builder) -> Unit =
        { turboLanding, resourcesBuilder ->
            val turbolandingId = turboLanding?.turbolandingId ?: 0L
            val turbolandingHref = turboLanding?.href ?: ""
            val turbolandingSite = turboLanding?.site ?: ""
            val turbolandingDomainFilter = turboLanding?.domainFilter ?: ""

            resourcesBuilder
                .setTurbolandingId(turbolandingId)
                .setTurbolandingHref(turbolandingHref)
                .setTurbolandingSite(turbolandingSite).turbolandingDomainFilter = turbolandingDomainFilter
        }
}
