package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.BannerVcardYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.VcardInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerVcardLoader

@Component
class BannerVcardHandler(
    loader: BannerVcardLoader,
    ytRepository: BannerVcardYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) : BaseBannerResourceHandler<VcardInfo>(
    loader, ytRepository, logBsExportEssService, caesarIterIdGenerator, bannerImageRepository, ppcPropertiesSupport
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_VCARD
    }

    override fun mapResourceToProto(): (VcardInfo, BannerResources.Builder) -> Unit =
        { vcardInfo, resourcesBuilder -> resourcesBuilder.vcardDomainFilter = vcardInfo.domainFilter }

}
