package ru.yandex.direct.logicprocessor.processors.bsexport.resources.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.OptionalMetrikaSnippet
import ru.yandex.direct.bstransport.yt.repository.resources.BannerZenSubscribeYtRepository
import ru.yandex.direct.bstransport.yt.utils.CaesarIterIdGenerator
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.log.service.LogBsExportEssService
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.ZenSubscribeInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerZenSubscribeLoader

@Component
class BannerZenSubscribeHandler(
    bannerZenSubscribeLoader: BannerZenSubscribeLoader,
    bannerZenSubscribeYtRepository: BannerZenSubscribeYtRepository,
    logBsExportEssService: LogBsExportEssService,
    caesarIterIdGenerator: CaesarIterIdGenerator,
    bannerImageRepository: BannerImageRepository,
    ppcPropertiesSupport: PpcPropertiesSupport,
) : BaseBannerResourceHandler<ZenSubscribeInfo?>(
    bannerZenSubscribeLoader,
    bannerZenSubscribeYtRepository,
    logBsExportEssService,
    caesarIterIdGenerator,
    bannerImageRepository,
    ppcPropertiesSupport,
) {
    override fun bannerResourceType(): BannerResourceType {
        return BannerResourceType.BANNER_ZEN_SUBSCRIBE
    }

    public override fun mapResourceToProto(): (ZenSubscribeInfo?, BannerResources.Builder) -> Unit {
        return { zenSubscribeInfo, resourcesBuilder ->
            zenSubscribeInfo?.publisherItemId?.let { resourcesBuilder.publisherItemId = it }
            zenSubscribeInfo?.metrikaSnippet?.let {
                resourcesBuilder.metrikaSnippet = OptionalMetrikaSnippet.newBuilder().setValue(it).build()
            } ?: run { resourcesBuilder.metrikaSnippet = OptionalMetrikaSnippet.newBuilder().build() }
        }
    }
}
