package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.adv.direct.banner.resources.Button;
import ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithButtonForBsExport;
import ru.yandex.direct.core.entity.hrefparams.service.HrefWithParamsBuildingService;

import static ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate.NO;
import static ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate.YES;
import static ru.yandex.direct.core.entity.banner.model.ButtonAction.toSource;

@Component
public class BannerButtonsLoader extends BaseBannerResourcesLoader<BannerWithButtonForBsExport, Button> {

    private static final Set<BannerButtonStatusModerate> STATUSES_MODERATE_TO_SEND = Set.of(YES, NO);

    private final HrefWithParamsBuildingService hrefWithParamsBuildingService;

    public BannerButtonsLoader(BannerResourcesLoaderContext context,
                               HrefWithParamsBuildingService hrefWithParamsBuildingService) {
        super(context);
        this.hrefWithParamsBuildingService = hrefWithParamsBuildingService;
    }

    @Override
    protected Class<BannerWithButtonForBsExport> getClassToLoadFromDb() {
        return BannerWithButtonForBsExport.class;
    }

    @Override
    protected Map<Long, Button> getResources(int shard, List<BannerWithButtonForBsExport> bannersFromDb) {
        Map<Long, Button> buttonMap = new HashMap<>();
        bannersFromDb.stream()
                .filter(this::hasReadyResource)
                .forEach(banner -> {
                    banner.setButtonHref(buildHref(shard, banner));
                    buttonMap.put(banner.getId(), getResource(banner));
                });
        return buttonMap;
    }

    private Button getResource(BannerWithButtonForBsExport banner) {
        return banner.getButtonStatusModerate().equals(NO) ? null :
                Button.newBuilder()
                        .setButtonKey(toSource(banner.getButtonAction()))
                        .setButtonCaption(banner.getButtonCaption())
                        .setButtonHref(banner.getButtonHref())
                        .build();
    }

    private boolean hasReadyResource(BannerWithButtonForBsExport resourceFromDb) {
        return Objects.nonNull(resourceFromDb.getButtonStatusModerate()) && STATUSES_MODERATE_TO_SEND.contains(resourceFromDb.getButtonStatusModerate());
    }

    private String buildHref(int shard, BannerWithButtonForBsExport banner) {
        return hrefWithParamsBuildingService
                .buildHrefWithParamsByAdGroupId(shard, banner.getAdGroupId(), banner.getButtonHref());
    }
}
