package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithGreenUrlTextsForBsExport;
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.GreenUrlTexts;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@Component
@ParametersAreNonnullByDefault
public class BannerGreenUrlTextsLoader
        extends BaseBannerResourcesLoader<BannerWithGreenUrlTextsForBsExport, GreenUrlTexts> {

    @Autowired
    public BannerGreenUrlTextsLoader(BannerResourcesLoaderContext context) {
        super(context);
    }

    @Override
    protected Class<BannerWithGreenUrlTextsForBsExport> getClassToLoadFromDb() {
        return BannerWithGreenUrlTextsForBsExport.class;
    }

    @Override
    protected Map<Long, GreenUrlTexts> getResources(int shard, List<BannerWithGreenUrlTextsForBsExport> banners) {
        return listToMap(banners, Banner::getId, this::toGreenUrlTexts);
    }

    private GreenUrlTexts toGreenUrlTexts(BannerWithGreenUrlTextsForBsExport banner) {
        return new GreenUrlTexts(banner.getDisplayHrefPrefix(), banner.getDisplayHrefSuffix());
    }
}
