package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.adv.direct.banner.resources.LeadButton;
import ru.yandex.direct.core.entity.banner.model.BannerWithLeadButtonForBsExport;

@Component
@ParametersAreNonnullByDefault
public class BannerLeadButtonLoader
        extends BaseBannerResourcesLoader<BannerWithLeadButtonForBsExport, LeadButton> {

    @Autowired
    public BannerLeadButtonLoader(BannerResourcesLoaderContext context) {
        super(context);
    }

    @Override
    protected Class<BannerWithLeadButtonForBsExport> getClassToLoadFromDb() {
        return BannerWithLeadButtonForBsExport.class;
    }

    @Override
    protected Map<Long, LeadButton> getResources(int shard, List<BannerWithLeadButtonForBsExport> banners) {
        Map<Long, LeadButton> leadButtonMap = new HashMap<>();
        banners.stream()
                .forEach(banner -> leadButtonMap.put(banner.getId(), toLeadButton(banner)));
        return leadButtonMap;
    }

    private LeadButton toLeadButton(BannerWithLeadButtonForBsExport banner) {
        return banner.getLeadformHref() == null || banner.getLeadformButtonText() == null ? null :
            LeadButton.newBuilder()
                .setHref(banner.getLeadformHref())
                .setText(banner.getLeadformButtonText())
                .build();
    }
}
