package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerNameStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithNameForBsExport;

import static ru.yandex.direct.core.entity.banner.model.BannerNameStatusModerate.NO;
import static ru.yandex.direct.core.entity.banner.model.BannerNameStatusModerate.YES;

@Component
public class BannerNamesLoader extends BaseBannerResourcesLoader<BannerWithNameForBsExport, String> {

    private static final Set<BannerNameStatusModerate> STATUSES_MODERATE_TO_SEND = Set.of(YES, NO);

    public BannerNamesLoader(BannerResourcesLoaderContext context) {
        super(context);
    }

    @Override
    protected Class<BannerWithNameForBsExport> getClassToLoadFromDb() {
        return BannerWithNameForBsExport.class;
    }

    @Override
    protected Map<Long, String> getResources(int shard, List<BannerWithNameForBsExport> bannersFromDb) {
        Map<Long, String> nameMap = new HashMap<>();
        bannersFromDb.stream()
                .filter(this::hasReadyResource)
                .forEach(banner -> nameMap.put(banner.getId(), getName(banner)));
        return nameMap;
    }

    private String getName(BannerWithNameForBsExport banner) {
        return banner.getNameStatusModerate().equals(NO) ? null : banner.getName();
    }

    private boolean hasReadyResource(BannerWithNameForBsExport resourceFromDb) {
        return Objects.nonNull(resourceFromDb.getNameStatusModerate())
                && STATUSES_MODERATE_TO_SEND.contains(resourceFromDb.getNameStatusModerate());
    }
}
