package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields
import ru.yandex.direct.core.entity.bs.common.service.BsOrderIdCalculator
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject

class BannerFromDbWithLogicObject<T : BannerWithSystemFields>(
    val bannerFromDb: T,
    val orderId: Long,
    val isDeleted: Boolean
) {
    val bid: Long
        get() = bannerFromDb.id
    val bsBannerId: Long
        get() = bannerFromDb.bsBannerId

    override fun toString(): String {
        return "BannerFromDbWithLogicObject{" +
            "bannerFromDb=" + bannerFromDb +
            ", orderId=" + orderId +
            ", isDeleted=" + isDeleted +
            '}'
    }
}

@Service
class BannerResourcesHelper(private val bsOrderIdCalculator: BsOrderIdCalculator) {
    fun <T : BannerWithSystemFields> getBidsToDbBanner(
        shard: Int, banners: List<T>, bidsToObjectMap: Map<Long, BsExportBannerResourcesObject> = emptyMap()
    ): Map<Long, BannerFromDbWithLogicObject<T>> {
        val cidToOrderId: Map<Long, Long> = getCidsToOrderIdMap(shard, banners)

        return banners.filter { banner: T ->
            cidToOrderId.containsKey(
                banner.campaignId
            )
        }.map { banner: T ->
            BannerFromDbWithLogicObject(
                banner, cidToOrderId[banner.campaignId]!!, getIsDeleted(bidsToObjectMap[banner.id])
            )
        }.associateBy { obj -> obj.bid }
    }

    private fun getIsDeleted(obj: BsExportBannerResourcesObject?): Boolean {
        return obj?.isDeleted ?: false
    }

    fun getCidsToOrderIdMap(
        shard: Int,
        banners: List<BannerWithSystemFields>,
    ): Map<Long, Long> {
        val campaignIds = banners.map { obj: BannerWithSystemFields -> obj.campaignId }.toSet()
        return bsOrderIdCalculator.calculateOrderIdIfNotExist(shard, campaignIds)
    }
}
